/*global define */
/*jslint white: true */

/*
	VisibleItem:

	This object provides a mixin for each visible item.
*/

define  ([  "src/utils",	"src/build/treeAmount"],
function(   utils,			treeAmount) {
	'use strict';

	function VisibleItem() {
		utils.assert(this !== undefined, "AudibleItem not called with new.");
		// do not modify these private members directly or notifiers won't be called correctly
		this.pVisibleItem = { 
			enabled			: true, 
			alpha			: 1, //% 0 to 1
			disabledAlpha	: undefined
		};
	}

	var ta = treeAmount({ 
		enabledLabel		: "enabled",
		amountLabel			: "alpha",
		disabledAmountLabel	: "disabledAlpha",
		changeNotifierType	: "visibleChanged",
		rename				: {	setAmount : "setAlpha",
								getAmount : "getAlpha",
								getEffectiveAmount : "getEffectiveAlpha",
								getAmountToRoot : "getAlphaToRoot",
								isRelevant : "isVisible",
								getEnabled : "getVisibleEnabled",
								setEnabled : "setVisibleEnabled" },
		getTreeInfo : function (obj) {
			return obj.pVisibleItem;
		}
	});

	utils.mixin(VisibleItem, ta, {
		clone : function (clone_children, other) {
			var result = other;

			if (result) {
				// init
				VisibleItem.call(result);
			} else {
				// alloc and init
				result = new VisibleItem();
			}

			utils.clone(false, result.pVisibleItem, this.pVisibleItem);

			return result;
		}
	});

	return VisibleItem;
});
